/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.util;

import com.anthonyhilyard.legendarytooltips.util.ItemColor;
import com.anthonyhilyard.legendarytooltips.util.TextColor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Selectors {
    private static final int TAG_COMPOUND = 10;
    private static final int TAG_LIST = 9;
    private static Map<String, EnumRarity> rarities = new HashMap<String, EnumRarity>(){
        {
            this.put("common", EnumRarity.COMMON);
            this.put("uncommon", EnumRarity.UNCOMMON);
            this.put("rare", EnumRarity.RARE);
            this.put("epic", EnumRarity.EPIC);
        }
    };
    private static Map<String, BiPredicate<NBTBase, String>> nbtComparators = new HashMap<String, BiPredicate<NBTBase, String>>(){
        {
            this.put("=", (tag, value) -> tag.toString().contentEquals((CharSequence)value));
            this.put("!=", (tag, value) -> !tag.toString().contentEquals((CharSequence)value));
            this.put(">", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NBTPrimitive) {
                        return ((NBTPrimitive)tag).func_150286_g() > parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
            this.put("<", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NBTPrimitive) {
                        return ((NBTPrimitive)tag).func_150286_g() < parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
    };

    public static boolean itemMatches(ItemStack item, String selector) {
        String itemResourceLocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.func_77973_b()).toString();
        int metadata = -1;
        String[] chunks = selector.split(":");
        if (chunks.length > 1) {
            try {
                metadata = Integer.parseInt(chunks[chunks.length - 1]);
                selector = selector.substring(0, selector.length() - chunks[chunks.length - 1].length() - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((selector.equals(itemResourceLocation) || selector.equals(itemResourceLocation.replace("minecraft:", ""))) && (metadata == -1 || metadata == item.func_77960_j())) {
            return true;
        }
        if (selector.startsWith("#")) {
            Integer entryColor = TextColor.parseColor(selector);
            if (entryColor != null && entryColor.equals(ItemColor.getColorForItem(item, 0xFFFFFF))) {
                return true;
            }
        } else if (selector.startsWith("!")) {
            if (item.func_77973_b().getForgeRarity(item) == rarities.get(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("@")) {
            if (itemResourceLocation.startsWith(selector.substring(1) + ":")) {
                return true;
            }
        } else if (selector.startsWith("$")) {
            if (OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)selector.substring(1)), (ItemStack[])new ItemStack[]{item})) {
                return true;
            }
        } else if (selector.startsWith("%")) {
            if (item.func_82833_r().contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("^")) {
            Minecraft mc = Minecraft.func_71410_x();
            List lines = item.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED);
            String tooltipText = "";
            for (int n = 1; n < lines.size(); ++n) {
                tooltipText = tooltipText + (String)lines.get(n) + '\n';
            }
            if (tooltipText.contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("&")) {
            String tagName = selector.substring(1);
            String tagValue = null;
            BiPredicate<NBTBase, String> valueChecker = null;
            for (String comparator : nbtComparators.keySet()) {
                if (!tagName.contains(comparator)) continue;
                valueChecker = nbtComparators.get(comparator);
                String[] components = tagName.split(comparator);
                tagName = components[0];
                if (components.length <= 1) break;
                tagValue = components[1];
                break;
            }
            return Selectors.findMatchingSubtag((NBTBase)item.func_77978_p(), tagName, tagValue, valueChecker);
        }
        return false;
    }

    private static boolean findMatchingSubtag(NBTBase tag, String key, String value, BiPredicate<NBTBase, String> valueChecker) {
        if (tag == null) {
            return false;
        }
        if (tag.func_74732_a() == 10) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            if (compoundTag.func_74764_b(key)) {
                if (value == null && valueChecker == null) {
                    return true;
                }
                return valueChecker.test(compoundTag.func_74781_a(key), value);
            }
            for (String innerKey : compoundTag.func_150296_c()) {
                if (compoundTag.func_150299_b(innerKey) != 9 && compoundTag.func_150299_b(innerKey) != 10 || !Selectors.findMatchingSubtag(compoundTag.func_74781_a(innerKey), key, value, valueChecker)) continue;
                return true;
            }
            return false;
        }
        if (tag.func_74732_a() == 9) {
            NBTTagList NBTTagList2 = (NBTTagList)tag;
            for (NBTBase innerTag : NBTTagList2) {
                if (innerTag.func_74732_a() != 9 && innerTag.func_74732_a() != 10 || !Selectors.findMatchingSubtag(innerTag, key, value, valueChecker)) continue;
                return true;
            }
        }
        return false;
    }
}

